var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { useEffectEvent, useSafely } from '@rocket.chat/fuselage-hooks';
import * as UiKit from '@rocket.chat/ui-kit';
import { useContext, useMemo, useState } from 'react';
import { UiKitContext } from '../contexts/UiKitContext';
import { getInitialValue } from '../utils/getInitialValue';
const getElementValueFromState = (actionId, values, initialValue) => { var _a, _b; return (_b = (values && ((_a = values[actionId]) === null || _a === void 0 ? void 0 : _a.value))) !== null && _b !== void 0 ? _b : initialValue; };
export const useUiKitState = (element, context) => {
    var _a;
    const { blockId, actionId, appId, dispatchActionConfig } = element;
    const { action, appId: appIdFromContext = undefined, viewId = undefined, updateState } = useContext(UiKitContext);
    const initialValue = getInitialValue(element);
    const { values, errors } = useContext(UiKitContext);
    const _value = getElementValueFromState(actionId, values, initialValue);
    const error = Array.isArray(errors)
        ? (_a = errors.find((error) => Object.keys(error).find((key) => key === actionId))) === null || _a === void 0 ? void 0 : _a[actionId]
        : errors === null || errors === void 0 ? void 0 : errors[actionId];
    const [value, setValue] = useSafely(useState(_value));
    const [loading, setLoading] = useSafely(useState(false));
    const actionFunction = useEffectEvent((e) => __awaiter(void 0, void 0, void 0, function* () {
        // FIXME: fix typings
        const { target: { value: elValue }, } = e;
        setLoading(true);
        if (Array.isArray(value)) {
            if (Array.isArray(elValue)) {
                setValue(elValue);
            }
            else {
                const idx = value.findIndex((value) => value === elValue);
                if (idx > -1) {
                    setValue(value.filter((_, i) => i !== idx));
                }
                else {
                    setValue([...value, elValue]);
                }
            }
        }
        else {
            setValue(elValue);
        }
        yield (updateState === null || updateState === void 0 ? void 0 : updateState({ blockId, appId, actionId, value: elValue, viewId }, e));
        yield action({
            blockId,
            appId: appId || appIdFromContext || 'core',
            actionId,
            value: elValue,
            viewId,
        }, e);
        setLoading(false);
    }));
    // Used for triggering actions on text inputs. Removing the load state
    // makes the text input field remain focused after running the action
    const noLoadStateActionFunction = useEffectEvent((e) => __awaiter(void 0, void 0, void 0, function* () {
        // FIXME: fix typings
        const { target: { value }, } = e;
        setValue(value);
        updateState && (yield updateState({ blockId, appId, actionId, value, viewId }, e));
        yield action({
            blockId,
            appId: appId || appIdFromContext || 'core',
            actionId,
            value,
            viewId,
            dispatchActionConfig,
        }, e);
    }));
    const stateFunction = useEffectEvent((e) => __awaiter(void 0, void 0, void 0, function* () {
        // FIXME: fix typings
        const { target: { value }, } = e;
        setValue(value);
        yield (updateState === null || updateState === void 0 ? void 0 : updateState({
            blockId,
            appId: appId || appIdFromContext || 'core',
            actionId,
            value,
            viewId,
        }, e));
    }));
    const result = useMemo(() => ({ loading, setLoading, error, value }), [loading, setLoading, error, value]);
    if (element.type === 'plain_text_input' &&
        Array.isArray(element === null || element === void 0 ? void 0 : element.dispatchActionConfig) &&
        element.dispatchActionConfig.includes('on_character_entered')) {
        return [result, noLoadStateActionFunction];
    }
    if ((context && [UiKit.BlockContext.SECTION, UiKit.BlockContext.ACTION].includes(context)) ||
        (Array.isArray(element === null || element === void 0 ? void 0 : element.dispatchActionConfig) && element.dispatchActionConfig.includes('on_item_selected'))) {
        return [result, actionFunction];
    }
    return [result, stateFunction];
};
//# sourceMappingURL=useUiKitState.js.map