import { jsx as _jsx } from "react/jsx-runtime";
import * as UiKit from '@rocket.chat/ui-kit';
import { FuselageSurfaceRenderer, renderTextObject } from './FuselageSurfaceRenderer';
import VideoConferenceBlock from '../blocks/VideoConferenceBlock';
import { AppIdProvider } from '../contexts/AppIdContext';
export class FuselageMessageSurfaceRenderer extends FuselageSurfaceRenderer {
    constructor() {
        super(['actions', 'context', 'divider', 'image', 'input', 'section', 'preview', 'video_conf', 'info_card']);
        this.plain_text = renderTextObject;
        this.mrkdwn = renderTextObject;
    }
    video_conf(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(VideoConferenceBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
}
//# sourceMappingURL=FuselageMessageSurfaceRenderer.js.map