import { jsx as _jsx } from "react/jsx-runtime";
import * as UiKit from '@rocket.chat/ui-kit';
import ActionsBlock from '../blocks/ActionsBlock';
import CalloutBlock from '../blocks/CalloutBlock';
import ContextBlock from '../blocks/ContextBlock';
import DividerBlock from '../blocks/DividerBlock';
import ImageBlock from '../blocks/ImageBlock';
import InfoCard from '../blocks/InfoCard';
import InputBlock from '../blocks/InputBlock';
import PreviewBlock from '../blocks/PreviewBlock';
import SectionBlock from '../blocks/SectionBlock';
import { AppIdProvider } from '../contexts/AppIdContext';
import ButtonElement from '../elements/ButtonElement';
import ChannelsSelectElement from '../elements/ChannelsSelectElement/ChannelsSelectElement';
import MultiChannelsSelectElement from '../elements/ChannelsSelectElement/MultiChannelsSelectElement';
import CheckboxElement from '../elements/CheckboxElement';
import DatePickerElement from '../elements/DatePickerElement';
import IconButtonElement from '../elements/IconButtonElement';
import IconElement from '../elements/IconElement';
import ImageElement from '../elements/ImageElement';
import LinearScaleElement from '../elements/LinearScaleElement';
import MarkdownTextElement from '../elements/MarkdownTextElement';
import MultiStaticSelectElement from '../elements/MultiStaticSelectElement';
import OverflowElement from '../elements/OverflowElement';
import PlainTextElement from '../elements/PlainTextElement';
import PlainTextInputElement from '../elements/PlainTextInputElement';
import RadioButtonElement from '../elements/RadioButtonElement';
import StaticSelectElement from '../elements/StaticSelectElement';
import TimePickerElement from '../elements/TimePickerElement';
import ToggleSwitchElement from '../elements/ToggleSwitchElement';
import MultiUsersSelectElement from '../elements/UsersSelectElement/MultiUsersSelectElement';
import UsersSelectElement from '../elements/UsersSelectElement/UsersSelectElement';
const textObjectRenderers = {
    plain_text: (textObject, index) => _jsx(PlainTextElement, { textObject: textObject }, index),
    mrkdwn: (textObject, index) => _jsx(MarkdownTextElement, { textObject: textObject }, index),
};
export const renderTextObject = (textObject, context, index) => {
    if (context === UiKit.BlockContext.BLOCK) {
        return null;
    }
    switch (textObject.type) {
        case 'plain_text':
            return textObjectRenderers.plain_text(textObject, index);
        case 'mrkdwn':
            return textObjectRenderers.mrkdwn(textObject, index);
    }
};
const isImageBlock = (_elementOrBlock, context) => context === UiKit.BlockContext.BLOCK;
export class FuselageSurfaceRenderer extends UiKit.SurfaceRenderer {
    constructor(allowedBlocks) {
        super(allowedBlocks || ['actions', 'context', 'divider', 'image', 'input', 'section', 'preview', 'info_card']);
    }
    plain_text(textObject, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return textObjectRenderers.plain_text(textObject, index);
    }
    mrkdwn(textObject, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return _jsx(MarkdownTextElement, { textObject: textObject }, index);
    }
    text(textObject, context, index) {
        if (textObject.type === 'mrkdwn') {
            return this.mrkdwn(textObject, context, index);
        }
        return this.plain_text(textObject, context, index);
    }
    actions(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(ActionsBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
    preview(block, context, index) {
        if (context !== UiKit.BlockContext.BLOCK) {
            return null;
        }
        return _jsx(PreviewBlock, { block: block, context: context, index: index, surfaceRenderer: this }, index);
    }
    context(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(ContextBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
    divider(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(DividerBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
    image(block, context, index) {
        if (isImageBlock(block, context)) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(ImageBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return _jsx(ImageElement, { block: block, context: context, index: index, surfaceRenderer: this }, index);
    }
    input(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(InputBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.element.actionId || index));
        }
        return null;
    }
    section(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(SectionBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
    button(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(ButtonElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
    }
    datepicker(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(DatePickerElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    static_select(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(StaticSelectElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    multi_static_select(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(MultiStaticSelectElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    overflow(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(OverflowElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
    }
    plain_text_input(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(PlainTextInputElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    linear_scale(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(LinearScaleElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    toggle_switch(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(ToggleSwitchElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    radio_button(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(RadioButtonElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    checkbox(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(CheckboxElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    callout(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(CalloutBlock, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
        }
        return null;
    }
    time_picker(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(TimePickerElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
    users_select(block, context, index) {
        if (context === UiKit.BlockContext.FORM) {
            return _jsx(UsersSelectElement, { block: block, context: context, index: index, surfaceRenderer: this });
        }
        return null;
    }
    channels_select(block, context, index) {
        if (context === UiKit.BlockContext.FORM) {
            return _jsx(ChannelsSelectElement, { block: block, context: context, index: index, surfaceRenderer: this });
        }
        return null;
    }
    multi_users_select(block, context, index) {
        if (context === UiKit.BlockContext.FORM) {
            return _jsx(MultiUsersSelectElement, { block: block, context: context, index: index, surfaceRenderer: this });
        }
        return null;
    }
    multi_channels_select(block, context, index) {
        if (context === UiKit.BlockContext.FORM) {
            return _jsx(MultiChannelsSelectElement, { block: block, context: context, index: index, surfaceRenderer: this });
        }
        return null;
    }
    info_card(block, context, index) {
        if (context !== UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(InfoCard, { block: block, context: context, index: index, surfaceRenderer: this }) }, index));
    }
    icon(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return _jsx(IconElement, { block: block, context: context, index: index, surfaceRenderer: this });
    }
    icon_button(block, context, index) {
        if (context === UiKit.BlockContext.BLOCK) {
            return null;
        }
        return (_jsx(AppIdProvider, { appId: block.appId, children: _jsx(IconButtonElement, { block: block, context: context, index: index, surfaceRenderer: this }) }, block.actionId || index));
    }
}
//# sourceMappingURL=FuselageSurfaceRenderer.js.map