import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { lazy, memo } from 'react';
import HeadingBlock from './blocks/HeadingBlock';
import OrderedListBlock from './blocks/OrderedListBlock';
import ParagraphBlock from './blocks/ParagraphBlock';
import QuoteBlock from './blocks/QuoteBlock';
import TaskList from './blocks/TaskListBlock';
import UnorderedListBlock from './blocks/UnorderedListBlock';
import BigEmojiBlock from './emoji/BigEmojiBlock';
import KatexErrorBoundary from './katex/KatexErrorBoundary';
const CodeBlock = lazy(() => import('./code/CodeBlock'));
const KatexBlock = lazy(() => import('./katex/KatexBlock'));
const Markup = ({ tokens }) => (_jsx(_Fragment, { children: tokens.map((block, index) => {
        switch (block.type) {
            case 'BIG_EMOJI':
                return _jsx(BigEmojiBlock, { emoji: block.value }, index);
            case 'PARAGRAPH':
                return _jsx(ParagraphBlock, { children: block.value }, index);
            case 'HEADING':
                return _jsx(HeadingBlock, { level: block.level, children: block.value }, index);
            case 'UNORDERED_LIST':
                return _jsx(UnorderedListBlock, { items: block.value }, index);
            case 'ORDERED_LIST':
                return _jsx(OrderedListBlock, { items: block.value }, index);
            case 'TASKS':
                return _jsx(TaskList, { tasks: block.value }, index);
            case 'QUOTE':
                return _jsx(QuoteBlock, { children: block.value }, index);
            case 'CODE':
                return _jsx(CodeBlock, { language: block.language, lines: block.value }, index);
            case 'KATEX':
                return (_jsx(KatexErrorBoundary, { code: block.value, children: _jsx(KatexBlock, { code: block.value }) }, index));
            case 'LINE_BREAK':
                return _jsx("br", {}, index);
            default:
                return null;
        }
    }) }));
export default memo(Markup);
//# sourceMappingURL=Markup.js.map