import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import ItalicSpan from './ItalicSpan';
import LinkSpan from './LinkSpan';
import PlainSpan from './PlainSpan';
import StrikeSpan from './StrikeSpan';
import CodeElement from '../code/CodeElement';
import EmojiElement from '../emoji/EmojiElement';
import ChannelMentionElement from '../mentions/ChannelMentionElement';
import UserMentionElement from '../mentions/UserMentionElement';
const BoldSpan = ({ children }) => (_jsx(_Fragment, { children: children.map((block, index) => {
        if (block.type === 'LINK' ||
            block.type === 'PLAIN_TEXT' ||
            block.type === 'STRIKE' ||
            block.type === 'ITALIC' ||
            block.type === 'INLINE_CODE') {
            return _jsx("strong", { children: renderBlockComponent(block, index) }, index);
        }
        return renderBlockComponent(block, index);
    }) }));
const renderBlockComponent = (block, index) => {
    switch (block.type) {
        case 'EMOJI':
            return _jsx(EmojiElement, Object.assign({}, block), index);
        case 'MENTION_USER':
            return _jsx(UserMentionElement, { mention: block.value.value }, index);
        case 'MENTION_CHANNEL':
            return _jsx(ChannelMentionElement, { mention: block.value.value }, index);
        case 'PLAIN_TEXT':
            return _jsx(PlainSpan, { text: block.value }, index);
        case 'LINK':
            return _jsx(LinkSpan, { href: block.value.src.value, label: block.value.label }, index);
        case 'STRIKE':
            return _jsx(StrikeSpan, { children: block.value }, index);
        case 'ITALIC':
            return _jsx(ItalicSpan, { children: block.value }, index);
        case 'INLINE_CODE':
            return _jsx(CodeElement, { code: block.value.value }, index);
        default:
            return null;
    }
};
export default BoldSpan;
//# sourceMappingURL=BoldSpan.js.map