import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { Fragment } from 'react';
import BoldSpan from './BoldSpan';
import ItalicSpan from './ItalicSpan';
import StrikeSpan from './StrikeSpan';
import PreviewCodeElement from '../code/PreviewCodeElement';
import PreviewColorElement from '../colors/PreviewColorElement';
import PreviewEmojiElement from '../emoji/PreviewEmojiElement';
import KatexErrorBoundary from '../katex/KatexErrorBoundary';
import PreviewKatexElement from '../katex/PreviewKatexElement';
import PreviewChannelMentionElement from '../mentions/PreviewChannelMentionElement';
import PreviewUserMentionElement from '../mentions/PreviewUserMentionElement';
const PreviewInlineElements = ({ children }) => (_jsx(_Fragment, { children: children.map((child, index) => {
        switch (child.type) {
            case 'BOLD':
                return _jsx(BoldSpan, { children: child.value }, index);
            case 'STRIKE':
                return _jsx(StrikeSpan, { children: child.value }, index);
            case 'ITALIC':
                return _jsx(ItalicSpan, { children: child.value }, index);
            case 'LINK':
                return (_jsx(PreviewInlineElements, { children: Array.isArray(child.value.label) ? child.value.label : [child.value.label] }, index));
            case 'PLAIN_TEXT':
                return _jsx(Fragment, { children: child.value }, index);
            case 'IMAGE':
                return _jsx(PreviewInlineElements, { children: [child.value.label] }, index);
            case 'MENTION_USER':
                return _jsx(PreviewUserMentionElement, { mention: child.value.value }, index);
            case 'MENTION_CHANNEL':
                return _jsx(PreviewChannelMentionElement, { mention: child.value.value }, index);
            case 'INLINE_CODE':
                return _jsx(PreviewCodeElement, { code: child.value.value }, index);
            case 'EMOJI':
                return _jsx(PreviewEmojiElement, Object.assign({}, child), index);
            case 'COLOR':
                return _jsx(PreviewColorElement, Object.assign({}, child.value), index);
            case 'INLINE_KATEX':
                return (_jsx(KatexErrorBoundary, { code: child.value, children: _jsx(PreviewKatexElement, { code: child.value }) }, index));
            default:
                return null;
        }
    }) }));
export default PreviewInlineElements;
//# sourceMappingURL=PreviewInlineElements.js.map