import { jsx as _jsx } from "react/jsx-runtime";
import katex from 'katex';
import { useMemo } from 'react';
import 'katex/dist/katex.css';
const KatexBlock = ({ code }) => {
    const html = useMemo(() => katex.renderToString(code, {
        displayMode: true,
        macros: {
            '\\href': '\\@secondoftwo',
        },
        maxSize: 100,
    }), [code]);
    return _jsx("div", { role: 'math', style: { overflowX: 'auto' }, "aria-label": code, dangerouslySetInnerHTML: { __html: html } });
};
export default KatexBlock;
//# sourceMappingURL=KatexBlock.js.map