import { jsx as _jsx } from "react/jsx-runtime";
import colors from '@rocket.chat/fuselage-tokens/colors.json';
import styled from '@rocket.chat/styled';
import { useState } from 'react';
import { ErrorBoundary } from 'react-error-boundary';
const Fallback = styled('span') `
	text-decoration: underline;
	text-decoration-color: ${colors.r400};
`;
const KatexErrorBoundary = ({ children, code }) => {
    const [error, setError] = useState(null);
    return _jsx(ErrorBoundary, { children: children, onError: setError, fallback: _jsx(Fallback, { title: error === null || error === void 0 ? void 0 : error.message, children: code }) });
};
export default KatexErrorBoundary;
//# sourceMappingURL=KatexErrorBoundary.js.map