import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Message } from '@rocket.chat/fuselage';
import { useButtonPattern } from '@rocket.chat/fuselage-hooks';
import { memo, useContext, useMemo } from 'react';
import { useTranslation } from 'react-i18next';
import { MarkupInteractionContext } from '../MarkupInteractionContext';
const handleUserMention = (mention, withSymbol) => withSymbol ? `@${mention}` : mention;
const UserMentionElement = ({ mention }) => {
    var _a;
    const { t } = useTranslation();
    const { resolveUserMention, onUserMentionClick, ownUserId, useRealName, showMentionSymbol, triggerProps } = useContext(MarkupInteractionContext);
    const resolved = useMemo(() => resolveUserMention === null || resolveUserMention === void 0 ? void 0 : resolveUserMention(mention), [mention, resolveUserMention]);
    const handleClick = useMemo(() => (resolved ? onUserMentionClick === null || onUserMentionClick === void 0 ? void 0 : onUserMentionClick(resolved) : undefined), [resolved, onUserMentionClick]);
    const buttonProps = useButtonPattern((e) => handleClick === null || handleClick === void 0 ? void 0 : handleClick(e));
    if (mention === 'all') {
        return (_jsx(Message.Highlight, { title: t('Mentions_all_room_members'), variant: 'relevant', children: handleUserMention('all', showMentionSymbol) }));
    }
    if (mention === 'here') {
        return (_jsx(Message.Highlight, { title: t('Mentions_online_room_members'), variant: 'relevant', children: handleUserMention('here', showMentionSymbol) }));
    }
    if (!resolved) {
        return _jsxs(_Fragment, { children: ["@", mention] });
    }
    return (_jsx(Message.Highlight, Object.assign({ variant: resolved._id === ownUserId ? 'critical' : 'other', title: resolved._id === ownUserId ? t('Mentions_you') : t('Mentions_user'), clickable: true }, buttonProps, triggerProps, { "data-uid": resolved._id, children: handleUserMention((_a = (useRealName ? resolved.name : resolved.username)) !== null && _a !== void 0 ? _a : mention, showMentionSymbol) })));
};
export default memo(UserMentionElement);
//# sourceMappingURL=UserMentionElement.js.map