"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceStatus = exports.indexExpire = exports.defaultPingInterval = void 0;
const models_1 = require("@rocket.chat/models");
const uuid_1 = require("uuid");
exports.defaultPingInterval = parseInt(String(process.env.MULTIPLE_INSTANCES_PING_INTERVAL)) || 10;
exports.indexExpire = (parseInt(String(process.env.MULTIPLE_INSTANCES_EXPIRE)) || Math.ceil((exports.defaultPingInterval * 3) / 60)) * 60;
const ID = (0, uuid_1.v4)();
const id = () => ID;
const currentInstance = {
    name: '',
    extraInformation: {},
};
let pingInterval;
function start() {
    stop();
    pingInterval = setInterval(async () => ping(), exports.defaultPingInterval * 1000);
}
function stop() {
    if (!pingInterval) {
        return;
    }
    clearInterval(pingInterval);
    pingInterval = null;
}
let createIndexes = async () => {
    await models_1.InstanceStatus.col
        .indexes()
        .catch(() => [])
        .then((result) => result.some((index) => {
        if (index.key && index.key._updatedAt === 1) {
            if (index.expireAfterSeconds !== exports.indexExpire && index.name) {
                models_1.InstanceStatus.col.dropIndex(index.name);
                return false;
            }
            return true;
        }
        return false;
    }))
        .then((created) => {
        if (!created) {
            models_1.InstanceStatus.col.createIndex({ _updatedAt: 1 }, { expireAfterSeconds: exports.indexExpire });
        }
    });
    createIndexes = async () => {
        // noop
    };
};
async function registerInstance(name, extraInformation) {
    createIndexes();
    currentInstance.name = name;
    currentInstance.extraInformation = extraInformation;
    const result = await models_1.InstanceStatus.upsertInstance({
        _id: id(),
        pid: process.pid,
        name,
        extraInformation: extraInformation,
    });
    start();
    process.on('exit', onExit);
    return result;
}
async function unregisterInstance() {
    try {
        const result = await models_1.InstanceStatus.removeInstanceById(id());
        stop();
        process.removeListener('exit', onExit);
        return result;
    }
    catch (e) {
        return e;
    }
}
async function updateConnections(connections) {
    await models_1.InstanceStatus.updateConnections(id(), connections);
}
async function ping() {
    const result = await models_1.InstanceStatus.setDocumentHeartbeat(ID);
    if (result.modifiedCount === 0) {
        await registerInstance(currentInstance.name, currentInstance.extraInformation);
    }
}
async function onExit() {
    await unregisterInstance();
}
exports.InstanceStatus = {
    defaultPingInterval: exports.defaultPingInterval,
    id,
    indexExpire: exports.indexExpire,
    registerInstance,
    updateConnections,
};
//# sourceMappingURL=index.js.map