"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sign = sign;
exports.verify = verify;
exports.getPairs = getPairs;
const jose_1 = require("jose");
async function sign(keyObject, pkcs8, alg = 'RS256') {
    const privateKey = await (0, jose_1.importPKCS8)(pkcs8, alg);
    const token = await new jose_1.SignJWT(keyObject).setProtectedHeader({ alg, typ: 'JWT' }).sign(privateKey);
    return token;
}
async function verify(jwt, spki, alg = 'RS256') {
    const publicKey = await (0, jose_1.importSPKI)(spki, alg);
    const { payload, protectedHeader } = await (0, jose_1.jwtVerify)(jwt, publicKey, {});
    return [payload, protectedHeader];
}
async function getPairs() {
    if (process.env.NODE_ENV !== 'test') {
        throw new Error('This function should only be used in tests');
    }
    const { publicKey, privateKey } = await (0, jose_1.generateKeyPair)('RS256');
    const spki = await (0, jose_1.exportSPKI)(publicKey);
    const pkcs8 = await (0, jose_1.exportPKCS8)(privateKey);
    return [spki, pkcs8];
}
//# sourceMappingURL=index.js.map