var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { AnimatedVisibility, PositionAnimated, Tooltip, } from '@rocket.chat/fuselage';
import { useDebouncedState } from '@rocket.chat/fuselage-hooks';
import { cloneElement, forwardRef, useCallback, useId, useMemo, useRef, } from 'react';
var getAnchor = function (children, params) {
    if (typeof children === 'function') {
        return children(params);
    }
    return cloneElement(children, {
        'ref': params.ref,
        'onMouseEnter': function () { return params.toggle(true); },
        'onMouseLeave': function () { return params.toggle(false); },
        'onFocus': function () { return params.toggle(true); },
        'onBlur': function () { return params.toggle(false); },
        'aria-describedby': params.id,
    });
};
// Workaround to the c̶r̶a̶p̶p̶y̶ not-so-great API of PositionAnimated
var InnerTooltip = forwardRef(function InnerTooltip(_a, ref) {
    var style = _a.style, props = __rest(_a, ["style"]);
    return (_jsx("div", { ref: ref, style: style, children: _jsx(Tooltip, __assign({}, props)) }));
});
var TooltipWrapper = function (_a) {
    var children = _a.children, text = _a.text;
    var anchorRef = useRef(null);
    var _b = useDebouncedState(false, 460), open = _b[0], setOpen = _b[1];
    var toggle = useCallback(function (open) {
        setOpen(open);
        if (open) {
            setOpen.flush();
        }
    }, [setOpen]);
    var id = useId();
    var anchorParams = useMemo(function () { return ({ ref: anchorRef, toggle: toggle, id: id }); }, [id, toggle]);
    var anchor = getAnchor(children, anchorParams);
    return (_jsxs(_Fragment, { children: [anchor, open && (_jsx(PositionAnimated, { anchor: anchorRef, placement: 'top-middle', margin: 8, visible: AnimatedVisibility.UNHIDING, children: _jsx(InnerTooltip, { id: id, "aria-hidden": 'false', onMouseEnter: function () { return setOpen(true); }, onMouseLeave: function () { return setOpen(false); }, children: text }) }))] }));
};
export default TooltipWrapper;
//# sourceMappingURL=TooltipWrapper.js.map