"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyLicenseOrRemove = exports.applyLicense = void 0;
const licenseImp_1 = require("./licenseImp");
const applyLicense = async (license, isNewLicense) => {
    const enterpriseLicense = (license ?? '').trim();
    if (!enterpriseLicense) {
        return false;
    }
    if (enterpriseLicense === licenseImp_1.License.encryptedLicense) {
        return false;
    }
    try {
        return licenseImp_1.License.setLicense(enterpriseLicense, isNewLicense);
    }
    catch {
        return false;
    }
};
exports.applyLicense = applyLicense;
const applyLicenseOrRemove = async (license, isNewLicense) => {
    const enterpriseLicense = (license ?? '').trim();
    if (!enterpriseLicense) {
        licenseImp_1.License.remove();
        return false;
    }
    if (enterpriseLicense === licenseImp_1.License.encryptedLicense) {
        return false;
    }
    try {
        return licenseImp_1.License.setLicense(enterpriseLicense, isNewLicense);
    }
    catch {
        licenseImp_1.License.remove();
        return false;
    }
};
exports.applyLicenseOrRemove = applyLicenseOrRemove;
//# sourceMappingURL=applyLicense.js.map