"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.moduleValidated = moduleValidated;
exports.moduleRemoved = moduleRemoved;
exports.behaviorTriggered = behaviorTriggered;
exports.behaviorTriggeredToggled = behaviorTriggeredToggled;
exports.licenseValidated = licenseValidated;
exports.licenseInvalidated = licenseInvalidated;
const logger_1 = require("../logger");
const modules_1 = require("../modules");
function moduleValidated(module) {
    try {
        const external = !(0, modules_1.isInternalModuleName)(module);
        this.emit('module', { module, external, valid: true });
    }
    catch (error) {
        logger_1.logger.error({ msg: `Error running module (valid: true) event: ${module}`, error });
    }
    try {
        this.emit(`valid:${module}`);
    }
    catch (error) {
        logger_1.logger.error({ msg: `Error running module added event: ${module}`, error });
    }
}
function moduleRemoved(module) {
    try {
        const external = !(0, modules_1.isInternalModuleName)(module);
        this.emit('module', { module, external, valid: false });
    }
    catch (error) {
        logger_1.logger.error({ msg: `Error running module (valid: false) event: ${module}`, error });
    }
    try {
        this.emit(`invalid:${module}`);
    }
    catch (error) {
        logger_1.logger.error({ msg: `Error running module removed event: ${module}`, error });
    }
}
function behaviorTriggered(options) {
    const { behavior, reason, modules: _, ...rest } = options;
    try {
        this.emit(`behavior:${behavior}`, {
            reason,
            ...rest,
        });
    }
    catch (error) {
        logger_1.logger.error({ msg: 'Error running behavior triggered event', error });
    }
    if (!['prevent_action'].includes(behavior)) {
        return;
    }
    if (reason !== 'limit' || !(`limit` in rest) || !rest.limit) {
        return;
    }
    try {
        this.emit(`limitReached:${rest.limit}`);
    }
    catch (error) {
        logger_1.logger.error({ msg: 'Error running limit reached event', error });
    }
}
function behaviorTriggeredToggled(options) {
    const { behavior, reason, modules: _, ...rest } = options;
    try {
        this.emit(`behaviorToggled:${behavior}`, {
            reason,
            ...rest,
        });
    }
    catch (error) {
        logger_1.logger.error({ msg: 'Error running behavior triggered event', error });
    }
}
function licenseValidated() {
    try {
        this.emit('validate');
    }
    catch (error) {
        logger_1.logger.error({ msg: 'Error running license validated event', error });
    }
}
function licenseInvalidated() {
    try {
        this.emit('invalidate');
    }
    catch (error) {
        logger_1.logger.error({ msg: 'Error running license invalidated event', error });
    }
}
//# sourceMappingURL=emitter.js.map