"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.overwriteClassOnLicense = overwriteClassOnLicense;
const deprecated_1 = require("./deprecated");
async function overwriteClassOnLicense(license, original, overwrite) {
    await deprecated_1.onLicense.call(this, license, () => {
        Object.entries(overwrite).forEach(([key, value]) => {
            const originalFn = original.prototype[key];
            original.prototype[key] = function (...args) {
                return value.call(this, originalFn, ...args);
            };
        });
    });
}
//# sourceMappingURL=overwriteClassOnLicense.js.map