"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInternalModuleName = isInternalModuleName;
exports.notifyValidatedModules = notifyValidatedModules;
exports.notifyInvalidatedModules = notifyInvalidatedModules;
exports.invalidateAll = invalidateAll;
exports.getModules = getModules;
exports.getModuleDefinition = getModuleDefinition;
exports.getExternalModules = getExternalModules;
exports.hasModule = hasModule;
exports.replaceModules = replaceModules;
const core_typings_1 = require("@rocket.chat/core-typings");
const emitter_1 = require("./events/emitter");
function isInternalModuleName(module) {
    return core_typings_1.CoreModules.includes(module);
}
function notifyValidatedModules(licenseModules) {
    licenseModules.forEach((module) => {
        this.modules.add(module);
        emitter_1.moduleValidated.call(this, module);
    });
}
function notifyInvalidatedModules(licenseModules) {
    licenseModules.forEach((module) => {
        emitter_1.moduleRemoved.call(this, module);
        this.modules.delete(module);
    });
}
function invalidateAll() {
    notifyInvalidatedModules.call(this, [...this.modules]);
    this.modules.clear();
}
function getModules() {
    return [...this.modules];
}
function getModuleDefinition(moduleName) {
    const license = this.getLicense();
    if (!license) {
        return;
    }
    const moduleDefinition = license.grantedModules.find(({ module }) => module === moduleName);
    return moduleDefinition;
}
function getExternalModules() {
    const license = this.getLicense();
    if (!license) {
        return [];
    }
    return [...license.grantedModules.filter((value) => !isInternalModuleName(value.module))];
}
function hasModule(module) {
    return this.modules.has(module);
}
function replaceModules(newModules) {
    let anyChange = false;
    for (const moduleName of newModules) {
        if (this.modules.has(moduleName)) {
            continue;
        }
        this.modules.add(moduleName);
        emitter_1.moduleValidated.call(this, moduleName);
        anyChange = true;
    }
    for (const moduleName of this.modules) {
        if (newModules.includes(moduleName)) {
            continue;
        }
        emitter_1.moduleRemoved.call(this, moduleName);
        this.modules.delete(moduleName);
        anyChange = true;
    }
    return anyChange;
}
//# sourceMappingURL=modules.js.map