"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setPendingLicense = setPendingLicense;
exports.applyPendingLicense = applyPendingLicense;
exports.hasPendingLicense = hasPendingLicense;
exports.isPendingLicense = isPendingLicense;
exports.clearPendingLicense = clearPendingLicense;
const logger_1 = require("./logger");
function setPendingLicense(encryptedLicense) {
    this.pendingLicense = encryptedLicense;
    if (this.pendingLicense) {
        logger_1.logger.info('Storing license as pending validation.');
    }
}
async function applyPendingLicense() {
    if (this.pendingLicense) {
        logger_1.logger.info('Applying pending license.');
        return this.setLicense(this.pendingLicense);
    }
}
function hasPendingLicense() {
    return Boolean(this.pendingLicense);
}
function isPendingLicense(encryptedLicense) {
    return !!this.pendingLicense && this.pendingLicense === encryptedLicense;
}
function clearPendingLicense() {
    if (this.pendingLicense) {
        logger_1.logger.info('Removing pending license.');
    }
    this.pendingLicense = '';
}
//# sourceMappingURL=pendingLicense.js.map