"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.showLicense = showLicense;
const modules_1 = require("./modules");
function showLicense(license, valid) {
    if (!process.env.LICENSE_DEBUG || process.env.LICENSE_DEBUG === 'false') {
        return;
    }
    if (!license || !valid) {
        return;
    }
    const { validation: { serverUrls, validPeriods }, limits, } = license;
    const modules = modules_1.getModules.call(this);
    console.log('---- License enabled ----');
    console.log('              url ->', JSON.stringify(serverUrls));
    console.log('          periods ->', JSON.stringify(validPeriods));
    console.log('           limits ->', JSON.stringify(limits));
    console.log('          modules ->', modules.join(', '));
    console.log('-------------------------');
}
//# sourceMappingURL=showLicense.js.map