"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addTag = addTag;
exports.replaceTags = replaceTags;
exports.getTags = getTags;
function addTag(tag) {
    // make sure to not add duplicated tag names
    for (const addedTag of this.tags) {
        if (addedTag.name.toLowerCase() === tag.name.toLowerCase()) {
            return;
        }
    }
    this.tags.add(tag);
}
function replaceTags(newTags) {
    this.tags.clear();
    for (const tag of newTags) {
        addTag.call(this, tag);
    }
}
function getTags() {
    return [...this.tags];
}
//# sourceMappingURL=tags.js.map