"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setLicenseLimitCounter = setLicenseLimitCounter;
exports.getCurrentValueForLicenseLimit = getCurrentValueForLicenseLimit;
exports.hasAllDataCounters = hasAllDataCounters;
const logger_1 = require("../logger");
const pendingLicense_1 = require("../pendingLicense");
function setLicenseLimitCounter(limitKey, fn) {
    this.dataCounters.set(limitKey, fn);
    if (pendingLicense_1.hasPendingLicense.call(this) && hasAllDataCounters.call(this)) {
        void pendingLicense_1.applyPendingLicense.call(this);
    }
}
async function getCurrentValueForLicenseLimit(limitKey, context) {
    const counterFn = this.dataCounters.get(limitKey);
    if (!counterFn) {
        logger_1.logger.error({ msg: 'Unable to validate license limit due to missing data counter.', limitKey });
        throw new Error(`Unable to validate license limit due to missing ${limitKey} data counter`);
    }
    return counterFn(context);
}
function hasAllDataCounters() {
    return ['activeUsers', 'guestUsers', 'roomsPerGuest', 'privateApps', 'marketplaceApps', 'monthlyActiveContacts'].every((limitKey) => this.dataCounters.has(limitKey));
}
//# sourceMappingURL=getCurrentValueForLicenseLimit.js.map