"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResultingBehavior = void 0;
const getResultingBehavior = (data, { reason, limit }) => {
    const behavior = 'invalidBehavior' in data ? data.invalidBehavior : data.behavior;
    switch (behavior) {
        case 'disable_modules':
            return {
                behavior,
                modules: ('modules' in data && data.modules) || [],
                reason,
                limit,
            };
        default:
            return {
                behavior,
                reason,
                limit,
            };
    }
};
exports.getResultingBehavior = getResultingBehavior;
//# sourceMappingURL=getResultingBehavior.js.map