"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BroadcastActorAgent = void 0;
const BaseAgent_1 = require("../base/BaseAgent");
const logger_1 = require("../logger");
const injection_1 = require("./injection");
/**
 * This agent doesn't implement any logic
 * What it does is send a notification to other instances reporting that a call has been updated;
 * Then if any server instance is keeping track of this call, it'll load its data from mongo and check what changed
 */
class BroadcastActorAgent extends BaseAgent_1.BaseMediaCallAgent {
    constructor() {
        super(...arguments);
        this.provider = null;
    }
    async onCallAccepted(callId, _signedContractId) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onCallAccepted', callId });
        this.reportCallUpdated({ callId });
    }
    async onCallEnded(callId) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onCallEnded', callId });
        this.reportCallUpdated({ callId });
    }
    async onCallActive(callId) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onCallActive', callId });
        this.reportCallUpdated({ callId });
    }
    async onCallCreated(call) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onCallCreated', call });
        // there's no point in broadcasting onCallCreated as it can only be called from within the call provider
    }
    async onRemoteDescriptionChanged(callId, negotiationId) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onRemoteDescriptionChanged', callId, negotiationId });
        this.reportCallUpdated({ callId });
    }
    async onCallTransferred(callId) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onCallTransferred', callId });
        this.reportCallUpdated({ callId });
    }
    async onDTMF(callId, dtmf, duration) {
        logger_1.logger.debug({ msg: 'BroadcastActorAgent.onDTMF', callId, dtmf, duration });
        this.reportCallUpdated({ callId, dtmf: { dtmf, duration } });
    }
    reportCallUpdated(params) {
        const { callId, ...otherParams } = params;
        if (this.provider?.callId === callId) {
            this.provider.reactToCallChanges(otherParams).catch(() => {
                (0, injection_1.getMediaCallServer)().reportCallUpdate(params);
            });
            return;
        }
        (0, injection_1.getMediaCallServer)().reportCallUpdate(params);
    }
}
exports.BroadcastActorAgent = BroadcastActorAgent;
//# sourceMappingURL=BroadcastAgent.js.map