"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildNewCallSignal = buildNewCallSignal;
const getNewCallTransferredBy_1 = require("./getNewCallTransferredBy");
function getCallFlags(call, role) {
    const flags = [];
    const isInternal = call.caller.type === 'user' && call.callee.type === 'user';
    const shouldCreateDataChannel = isInternal && role === 'caller';
    if (isInternal) {
        flags.push('internal');
        if (shouldCreateDataChannel) {
            flags.push('create-data-channel');
        }
    }
    return flags;
}
function buildNewCallSignal(call, role) {
    const self = role === 'caller' ? call.caller : call.callee;
    const contact = role === 'caller' ? call.callee : call.caller;
    const transferredBy = (0, getNewCallTransferredBy_1.getNewCallTransferredBy)(call);
    const flags = getCallFlags(call, role);
    return {
        callId: call._id,
        type: 'new',
        service: call.service,
        kind: call.kind,
        role,
        self: { ...self },
        contact: { ...contact },
        flags,
        ...(call.parentCallId && { replacingCallId: call.parentCallId }),
        ...(transferredBy && { transferredBy }),
        ...(call.callerRequestedId && role === 'caller' && { requestedCallId: call.callerRequestedId }),
    };
}
//# sourceMappingURL=buildNewCallSignal.js.map