"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripSensitiveDataFromSdp = stripSensitiveDataFromSdp;
exports.stripSensitiveDataFromSignal = stripSensitiveDataFromSignal;
function stripSensitiveDataFromSdp(sdp) {
    if (!sdp?.sdp) {
        return sdp;
    }
    const { ...data } = sdp;
    return {
        ...data,
        sdp: `length=${sdp.sdp.length}`,
    };
}
function stripSensitiveDataFromSignal(signal) {
    const { ...data } = signal;
    if ('sdp' in data) {
        data.sdp = stripSensitiveDataFromSdp(data.sdp);
    }
    return data;
}
//# sourceMappingURL=stripSensitiveData.js.map