"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageTypes = void 0;
class MessageTypes {
    constructor() {
        this.types = new Map();
    }
    registerType(options) {
        this.types.set(options.id, options);
    }
    getType(message) {
        return message.t ? this.types.get(message.t) : undefined;
    }
    isSystemMessage(message) {
        return this.getType(message)?.system ?? false;
    }
}
exports.MessageTypes = MessageTypes;
//# sourceMappingURL=MessageTypes.js.map