"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_typings_1 = require("@rocket.chat/core-typings");
const moment_1 = __importDefault(require("moment"));
exports.default = (instance) => {
    instance.registerType({
        id: 'voip-call-started',
        system: true,
        text: (t) => t('Voip_call_started'),
    });
    instance.registerType({
        id: 'voip-call-duration',
        system: true,
        text: (t, message) => {
            if (!(0, core_typings_1.isVoipMessage)(message)) {
                return t('Voip_call_duration', { duration: '' });
            }
            const seconds = (message.voipData.callDuration || 0) / 1000;
            const duration = moment_1.default.duration(seconds, 'seconds').humanize();
            return t('Voip_call_duration', { duration });
        },
    });
    instance.registerType({
        id: 'voip-call-declined',
        system: true,
        text: (t) => t('Voip_call_declined'),
    });
    instance.registerType({
        id: 'voip-call-on-hold',
        system: true,
        text: (t) => t('Voip_call_on_hold'),
    });
    instance.registerType({
        id: 'voip-call-unhold',
        system: true,
        text: (t) => t('Voip_call_unhold'),
    });
    instance.registerType({
        id: 'voip-call-ended',
        system: true,
        text: (t) => t('Voip_call_ended'),
    });
    instance.registerType({
        id: 'voip-call-ended-unexpectedly',
        system: true,
        text: (t, message) => t('Voip_call_ended_unexpectedly', { reason: message.msg }),
    });
    instance.registerType({
        id: 'voip-call-wrapup',
        system: true,
        text: (t, message) => t('Voip_call_wrapup', { comment: message.msg }),
    });
};
//# sourceMappingURL=voip.js.map