"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsTokensRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class AppsTokensRaw extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, '_raix_push_app_tokens', undefined, { collectionNameResolver: (name) => name });
    }
    countApnTokens() {
        const query = {
            'token.apn': { $exists: true },
        };
        return this.countDocuments(query);
    }
    countGcmTokens() {
        const query = {
            'token.gcm': { $exists: true },
        };
        return this.countDocuments(query);
    }
    countTokensByUserId(userId) {
        const query = {
            userId,
            $or: [{ 'token.apn': { $exists: true } }, { 'token.gcm': { $exists: true } }],
        };
        return this.countDocuments(query);
    }
}
exports.AppsTokensRaw = AppsTokensRaw;
//# sourceMappingURL=AppsTokens.js.map