"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseUploadModelRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class BaseUploadModelRaw extends BaseRaw_1.BaseRaw {
    modelIndexes() {
        return [
            { key: { name: 1 }, sparse: true },
            { key: { rid: 1 }, sparse: true },
            { key: { expiresAt: 1 }, sparse: true },
        ];
    }
    async insertFileInit(userId, store, file, extra = {}) {
        const fileData = {
            userId,
            store,
            complete: false,
            uploading: true,
            progress: 0,
            extension: file.name.split('.').pop(),
            uploadedAt: new Date(),
            ...file,
            ...extra,
        };
        if (fileData.type) {
            fileData.typeGroup = fileData.type.split('/').shift();
        }
        return this.insertOne(fileData);
    }
    updateFileComplete(fileId, userId, file) {
        if (!fileId) {
            return;
        }
        const filter = {
            _id: fileId,
            userId,
        };
        const update = {
            $set: {
                complete: true,
                uploading: false,
                progress: 1,
            },
        };
        update.$set = Object.assign(file, update.$set);
        if (update.$set.type) {
            update.$set.typeGroup = update.$set.type.split('/').shift();
        }
        return this.updateOne(filter, update);
    }
    confirmTemporaryFile(fileId, userId) {
        if (!fileId) {
            return;
        }
        const filter = {
            _id: fileId,
            userId,
        };
        const update = {
            $unset: {
                expiresAt: 1,
            },
        };
        return this.updateOne(filter, update);
    }
    async findOneByName(name, options) {
        return this.findOne({ name }, { session: options?.session });
    }
    async findOneByRoomId(rid) {
        return this.findOne({ rid });
    }
    findExpiredTemporaryFiles(options) {
        return this.find({
            expiresAt: {
                $lte: new Date(),
            },
        }, options);
    }
    async updateFileNameById(fileId, name) {
        const filter = { _id: fileId };
        const update = {
            $set: {
                name,
            },
        };
        return this.updateOne(filter, update);
    }
    async deleteFile(fileId, options) {
        return this.deleteOne({ _id: fileId }, { session: options?.session });
    }
}
exports.BaseUploadModelRaw = BaseUploadModelRaw;
//# sourceMappingURL=BaseUploadModel.js.map