"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CredentialTokensRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class CredentialTokensRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'credential_tokens', trash);
    }
    modelIndexes() {
        return [{ key: { expireAt: 1 }, sparse: true, expireAfterSeconds: 0 }];
    }
    async create(_id, userInfo) {
        const validForMilliseconds = 60000; // Valid for 60 seconds
        const token = {
            _id,
            userInfo,
            expireAt: new Date(Date.now() + validForMilliseconds),
        };
        await this.insertOne(token);
        return token;
    }
    findOneNotExpiredById(_id) {
        const query = {
            _id,
            expireAt: { $gt: new Date() },
        };
        return this.findOne(query);
    }
}
exports.CredentialTokensRaw = CredentialTokensRaw;
//# sourceMappingURL=CredentialTokens.js.map