"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomUserStatusRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class CustomUserStatusRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'custom_user_status', trash);
    }
    modelIndexes() {
        return [{ key: { name: 1 } }];
    }
    async findOneByName(name, options) {
        return options ? this.findOne({ name }, options) : this.findOne({ name });
    }
    // find
    findByName(name, options) {
        const query = {
            name,
        };
        return this.find(query, options);
    }
    findByNameExceptId(name, except, options) {
        const query = {
            _id: { $nin: [except] },
            name,
        };
        return this.find(query, options);
    }
    // update
    setName(_id, name) {
        const update = {
            $set: {
                name,
            },
        };
        return this.updateOne({ _id }, update);
    }
    setStatusType(_id, statusType) {
        const update = {
            $set: {
                statusType,
            },
        };
        return this.updateOne({ _id }, update);
    }
    // INSERT
    create(data) {
        return this.insertOne(data);
    }
}
exports.CustomUserStatusRaw = CustomUserStatusRaw;
//# sourceMappingURL=CustomUserStatus.js.map