"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailInboxRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class EmailInboxRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'email_inbox', trash);
    }
    modelIndexes() {
        return [{ key: { email: 1 }, unique: true }];
    }
    async setDisabledById(id) {
        return this.findOneAndUpdate({ _id: id, active: true }, { $set: { active: false } }, { returnDocument: 'after' });
    }
    async create(emailInbox) {
        return this.insertOne(emailInbox);
    }
    async updateById(id, data) {
        // findOneAndUpdate doesn't accept generics, so we had to type cast
        return this.findOneAndUpdate({ _id: id }, data, {
            returnDocument: 'after',
            projection: { _id: 1 },
        });
    }
    findActive() {
        return this.find({ active: true });
    }
    async findByEmail(email) {
        return this.findOne({ email });
    }
}
exports.EmailInboxRaw = EmailInboxRaw;
//# sourceMappingURL=EmailInbox.js.map