"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FederationKeysRaw = void 0;
const node_rsa_1 = __importDefault(require("node-rsa"));
const BaseRaw_1 = require("./BaseRaw");
class FederationKeysRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'federation_keys', trash);
    }
    async getKey(type) {
        const keyResource = await this.findOne({ type });
        if (!keyResource) {
            return null;
        }
        return keyResource.key;
    }
    loadKey(keyData, type) {
        return new node_rsa_1.default(keyData, `pkcs8-${type}-pem`);
    }
    async generateKeys() {
        const key = new node_rsa_1.default({ b: 2048 });
        key.generateKeyPair();
        await this.deleteMany({});
        await this.insertOne({
            type: 'private',
            key: key.exportKey('pkcs8-private-pem').replace(/\n|\r/g, ''),
        });
        await this.insertOne({
            type: 'public',
            key: key.exportKey('pkcs8-public-pem').replace(/\n|\r/g, ''),
        });
        return {
            privateKey: await this.getPrivateKey(),
            publicKey: await this.getPublicKey(),
        };
    }
    async getPrivateKey() {
        const keyData = await this.getKey('private');
        return keyData && this.loadKey(keyData, 'private');
    }
    getPrivateKeyString() {
        return this.getKey('private');
    }
    async getPublicKey() {
        const keyData = await this.getKey('public');
        return keyData && this.loadKey(keyData, 'public');
    }
    getPublicKeyString() {
        return this.getKey('public');
    }
}
exports.FederationKeysRaw = FederationKeysRaw;
//# sourceMappingURL=FederationKeys.js.map