"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportDataRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class ImportDataRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'import_data', trash);
    }
    modelIndexes() {
        return [{ key: { dataType: 1 } }];
    }
    getAllUsers() {
        return this.find({ dataType: 'user' });
    }
    getAllMessages() {
        return this.find({ dataType: 'message' });
    }
    getAllChannels() {
        return this.find({ dataType: 'channel' });
    }
    getAllUsersForSelection() {
        return this.find({
            dataType: 'user',
        }, {
            projection: {
                'data.importIds': 1,
                'data.username': 1,
                'data.emails': 1,
                'data.deleted': 1,
                'data.type': 1,
            },
        }).toArray();
    }
    getAllChannelsForSelection() {
        return this.find({
            'dataType': 'channel',
            'data.t': {
                $ne: 'd',
            },
        }, {
            projection: {
                'data.importIds': 1,
                'data.name': 1,
                'data.archived': 1,
                'data.t': 1,
            },
        }).toArray();
    }
    getAllContactsForSelection() {
        return this.find({
            dataType: 'contact',
        }, {
            projection: {
                'data.importIds': 1,
                'data.name': 1,
                'data.phones': 1,
                'data.emails': 1,
            },
        }).toArray();
    }
    async checkIfDirectMessagesExists() {
        return ((await this.countDocuments({
            'dataType': 'channel',
            'data.t': 'd',
        })) > 0);
    }
    async countMessages() {
        return this.countDocuments({ dataType: 'message' });
    }
    async findChannelImportIdByNameOrImportId(channelIdentifier) {
        const channel = await this.findOne({
            dataType: 'channel',
            $or: [
                {
                    'data.name': channelIdentifier,
                },
                {
                    'data.importIds': channelIdentifier,
                },
            ],
        }, {
            projection: {
                'data.importIds': 1,
            },
        });
        return channel?.data?.importIds?.shift();
    }
}
exports.ImportDataRaw = ImportDataRaw;
//# sourceMappingURL=ImportData.js.map