"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceStatusRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class InstanceStatusRaw extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, 'instances', undefined, {
            preventSetUpdatedAt: true,
            collectionNameResolver(name) {
                return name;
            },
        });
    }
    async getActiveInstanceCount() {
        return this.countDocuments({ _updatedAt: { $gt: new Date(Date.now() - process.uptime() * 1000 - 2000) } });
    }
    watchActiveInstances() {
        return this.col.watch();
    }
    async removeInstanceById(_id) {
        return this.deleteOne({ _id });
    }
    async setDocumentHeartbeat(documentId) {
        return this.updateOne({ _id: documentId }, { $currentDate: { _updatedAt: true } });
    }
    async upsertInstance(instance) {
        return this.findOneAndUpdate({
            _id: instance._id,
        }, {
            $set: instance,
            $currentDate: {
                _createdAt: true,
                _updatedAt: true,
            },
        }, {
            upsert: true,
            returnDocument: 'after',
        });
    }
    async updateConnections(_id, conns) {
        return this.updateOne({
            _id,
        }, {
            $set: {
                'extraInformation.conns': conns,
            },
        });
    }
}
exports.InstanceStatusRaw = InstanceStatusRaw;
//# sourceMappingURL=InstanceStatus.js.map