"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationHistoryRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class IntegrationHistoryRaw extends BaseRaw_1.BaseRaw {
    constructor(db) {
        super(db, 'integration_history');
    }
    modelIndexes() {
        return [
            { key: { 'integration._id': 1, 'integration._createdBy._id': 1 } },
            { key: { _updatedAt: 1 }, expireAfterSeconds: 30 * 24 * 60 * 60 },
        ];
    }
    removeByIntegrationId(integrationId) {
        return this.deleteMany({ 'integration._id': integrationId });
    }
    findOneByIntegrationIdAndHistoryId(integrationId, historyId) {
        return this.findOne({ 'integration._id': integrationId, '_id': historyId });
    }
    async create(integrationHistory) {
        return this.insertOne({ ...integrationHistory, _createdAt: new Date() });
    }
    async updateById(_id, data, options) {
        return this.findOneAndUpdate({ _id }, { $set: data }, { returnDocument: 'after', ...options });
    }
}
exports.IntegrationHistoryRaw = IntegrationHistoryRaw;
//# sourceMappingURL=IntegrationHistory.js.map