"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LivechatBusinessHoursRaw = void 0;
const core_typings_1 = require("@rocket.chat/core-typings");
const BaseRaw_1 = require("./BaseRaw");
class LivechatBusinessHoursRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'livechat_business_hours', trash);
    }
    findOneDefaultBusinessHour(options) {
        return this.findOne({ type: core_typings_1.LivechatBusinessHourTypes.DEFAULT }, options);
    }
    findActiveAndOpenBusinessHoursByDay(day, options) {
        return this.find({
            active: true,
            workHours: {
                $elemMatch: {
                    $or: [{ 'start.cron.dayOfWeek': day }, { 'finish.cron.dayOfWeek': day }],
                    open: true,
                },
            },
        }, options).toArray();
    }
    findActiveBusinessHours(options = {}) {
        return this.find({
            active: true,
        }, options).toArray();
    }
    findDefaultActiveAndOpenBusinessHoursByDay(day, options) {
        return this.find({
            type: core_typings_1.LivechatBusinessHourTypes.DEFAULT,
            active: true,
            workHours: {
                $elemMatch: {
                    $or: [{ 'start.cron.dayOfWeek': day }, { 'finish.cron.dayOfWeek': day }],
                    open: true,
                },
            },
        }, options).toArray();
    }
    async insertOne(data) {
        return super.insertOne({
            ...data,
            ts: new Date(),
        });
    }
    findHoursToScheduleJobs() {
        return this.col
            .aggregate([
            {
                $facet: {
                    start: [
                        { $match: { active: true } },
                        { $project: { _id: 0, workHours: 1 } },
                        { $unwind: { path: '$workHours' } },
                        { $match: { 'workHours.open': true } },
                        {
                            $group: {
                                _id: { day: '$workHours.start.cron.dayOfWeek' },
                                times: { $addToSet: '$workHours.start.cron.time' },
                            },
                        },
                        {
                            $project: {
                                _id: 0,
                                day: '$_id.day',
                                times: 1,
                            },
                        },
                    ],
                    finish: [
                        { $match: { active: true } },
                        { $project: { _id: 0, workHours: 1 } },
                        { $unwind: { path: '$workHours' } },
                        { $match: { 'workHours.open': true } },
                        {
                            $group: {
                                _id: { day: '$workHours.finish.cron.dayOfWeek' },
                                times: { $addToSet: '$workHours.finish.cron.time' },
                            },
                        },
                        {
                            $project: {
                                _id: 0,
                                day: '$_id.day',
                                times: 1,
                            },
                        },
                    ],
                },
            },
        ])
            .toArray();
    }
    async findActiveBusinessHoursToOpen(day, start, type, options) {
        const query = {
            active: true,
            workHours: {
                $elemMatch: {
                    'start.cron.dayOfWeek': day,
                    'start.cron.time': start,
                    'open': true,
                },
            },
        };
        if (type) {
            query.type = type;
        }
        return this.col.find(query, options).toArray();
    }
    async findActiveBusinessHoursToClose(day, finish, type, options) {
        const query = {
            active: true,
            workHours: {
                $elemMatch: {
                    'finish.cron.dayOfWeek': day,
                    'finish.cron.time': finish,
                    'open': true,
                },
            },
        };
        if (type) {
            query.type = type;
        }
        return this.col.find(query, options).toArray();
    }
    disableBusinessHour(businessHourId) {
        return this.updateOne({ _id: businessHourId }, { $set: { active: false } });
    }
}
exports.LivechatBusinessHoursRaw = LivechatBusinessHoursRaw;
//# sourceMappingURL=LivechatBusinessHours.js.map