"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LivechatCustomFieldRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class LivechatCustomFieldRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'livechat_custom_field', trash);
    }
    modelIndexes() {
        return [{ key: { scope: 1 } }];
    }
    findByScope(scope, options, includeHidden = true) {
        return this.find({ scope, ...(includeHidden === true ? {} : { visibility: { $ne: 'hidden' } }) }, options);
    }
    findMatchingCustomFields(scope, searchable = true, options) {
        const query = {
            scope,
            searchable,
        };
        return this.find(query, options);
    }
    findMatchingCustomFieldsByIds(ids, scope, searchable = true, options) {
        const query = {
            _id: { $in: ids },
            scope,
            searchable,
        };
        return this.find(query, options);
    }
    async createOrUpdateCustomField(_id, field, label, scope, visibility, extraData) {
        const record = {
            label,
            scope,
            visibility,
            ...extraData,
        };
        if (_id) {
            await this.updateOne({ _id }, { $set: record });
        }
        else {
            record._id = field;
            await this.insertOne(record);
        }
        return record;
    }
    findByIdsAndScope(ids, scope, options) {
        return this.find({ _id: { $in: ids }, scope }, options);
    }
}
exports.LivechatCustomFieldRaw = LivechatCustomFieldRaw;
//# sourceMappingURL=LivechatCustomField.js.map