"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaCallChannelsRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class MediaCallChannelsRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'media_call_channels', trash);
    }
    modelIndexes() {
        return [
            {
                key: { callId: 1, actorType: 1, actorId: 1, contractId: 1 },
                unique: true,
            },
        ];
    }
    findOneByCallIdAndSignedActor(params, options) {
        const { callId, type: actorType, id: actorId, contractId } = params;
        return this.findOne({
            callId,
            actorType,
            actorId,
            contractId,
        }, options);
    }
    updateOneById(_id, update, options) {
        return this.updateOne({ _id }, update, options);
    }
    createOrUpdateChannel(channel) {
        return this.findOneAndUpdate({
            callId: channel.callId,
            actorType: channel.actorType,
            actorId: channel.actorId,
            contractId: channel.contractId,
        }, {
            $setOnInsert: {
                ...channel,
            },
        }, {
            upsert: true,
            returnDocument: 'after',
        });
    }
    async setState(_id, state) {
        return this.updateOneById(_id, { $set: { state } });
    }
    async setActiveById(_id) {
        return this.updateOne({ _id, activeAt: { $exists: false } }, { $set: { state: 'active', activeAt: new Date() } });
    }
}
exports.MediaCallChannelsRaw = MediaCallChannelsRaw;
//# sourceMappingURL=MediaCallChannels.js.map