"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageReadsRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class MessageReadsRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'message_reads', trash);
    }
    modelIndexes() {
        return [{ key: { tmid: 1, userId: 1 }, unique: true }, { key: { ls: 1 } }];
    }
    async findOneByUserIdAndThreadId(userId, tmid) {
        return this.findOne({ userId, tmid });
    }
    getMinimumLastSeenByThreadId(tmid) {
        return this.findOne({
            tmid,
        }, {
            sort: {
                ls: 1,
            },
        });
    }
    updateReadTimestampByUserIdAndThreadId(userId, tmid) {
        const query = {
            userId,
            tmid,
        };
        const update = {
            $set: {
                ls: new Date(),
            },
        };
        return this.updateOne(query, update, { upsert: true });
    }
    async countByThreadAndUserIds(tmid, userIds) {
        const query = {
            tmid,
            userId: { $in: userIds },
        };
        return this.countDocuments(query);
    }
    async countByThreadId(tmid) {
        const query = {
            tmid,
        };
        return this.countDocuments(query);
    }
}
exports.MessageReadsRaw = MessageReadsRaw;
//# sourceMappingURL=MessageReads.js.map