"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsRaw = void 0;
const BaseRaw_1 = require("./BaseRaw");
class PermissionsRaw extends BaseRaw_1.BaseRaw {
    constructor(db, trash) {
        super(db, 'permissions', trash);
    }
    modelIndexes() {
        return [
            {
                key: {
                    level: 1,
                    settingId: 1,
                },
            },
        ];
    }
    async createOrUpdate(name, roles) {
        const exists = await this.findOne({
            _id: name,
            roles,
        }, { projection: { _id: 1 } });
        if (exists) {
            return exists._id;
        }
        await this.updateOne({ _id: name }, { $set: { roles } }, { upsert: true });
        return name;
    }
    async create(id, roles) {
        const exists = await this.findOneById(id, { projection: { _id: 1 } });
        if (exists) {
            return exists._id;
        }
        await this.updateOne({ _id: id }, { $set: { roles } }, { upsert: true });
        return id;
    }
    async addRole(permission, role) {
        await this.updateOne({ _id: permission, roles: { $ne: role } }, { $addToSet: { roles: role } });
    }
    async setRoles(permission, roles) {
        await this.updateOne({ _id: permission }, { $set: { roles } });
    }
    async removeRole(permission, role) {
        await this.updateOne({ _id: permission, roles: role }, { $pull: { roles: role } });
    }
    findByLevel(level, settingId) {
        return this.find({ level, ...(settingId && { settingId }) });
    }
}
exports.PermissionsRaw = PermissionsRaw;
//# sourceMappingURL=Permissions.js.map