"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWatchCollections = getWatchCollections;
const index_1 = require("./index");
const { DBWATCHER_EXCLUDE_COLLECTIONS = '', DBWATCHER_ONLY_COLLECTIONS = '' } = process.env;
const excludeCollections = DBWATCHER_EXCLUDE_COLLECTIONS.split(',')
    .map((collection) => collection.trim())
    .filter(Boolean);
const onlyCollections = DBWATCHER_ONLY_COLLECTIONS.split(',')
    .map((collection) => collection.trim())
    .filter(Boolean);
function getWatchCollections() {
    const collections = [];
    // add back to the list of collections in case db watchers are enabled
    if (!index_1.dbWatchersDisabled) {
        collections.push(index_1.InstanceStatus.getCollectionName());
        collections.push(index_1.Users.getCollectionName());
        collections.push(index_1.Messages.getCollectionName());
        collections.push(index_1.LivechatInquiry.getCollectionName());
        collections.push(index_1.Roles.getCollectionName());
        collections.push(index_1.Rooms.getCollectionName());
        collections.push(index_1.PbxEvents.getCollectionName());
        collections.push(index_1.Integrations.getCollectionName());
        collections.push(index_1.Permissions.getCollectionName());
        collections.push(index_1.LivechatPriority.getCollectionName());
        collections.push(index_1.LoginServiceConfiguration.getCollectionName());
        collections.push(index_1.EmailInbox.getCollectionName());
        collections.push(index_1.IntegrationHistory.getCollectionName());
        collections.push(index_1.Subscriptions.getCollectionName());
        collections.push(index_1.Settings.getCollectionName());
        collections.push(index_1.LivechatDepartmentAgents.getCollectionName());
    }
    if (onlyCollections.length > 0) {
        return collections.filter((collection) => onlyCollections.includes(collection));
    }
    if (excludeCollections.length > 0) {
        return collections.filter((collection) => !excludeCollections.includes(collection));
    }
    return collections;
}
//# sourceMappingURL=watchCollections.js.map