import { isIndexable, isNumericKey, isPlainObject } from './common';
const buildResult = (arrayIndices, dontIterate, value) => {
    if (arrayIndices === null || arrayIndices === void 0 ? void 0 : arrayIndices.length) {
        if (dontIterate) {
            return [{ arrayIndices, dontIterate, value }];
        }
        return [{ arrayIndices, value }];
    }
    if (dontIterate) {
        return [{ dontIterate, value }];
    }
    return [{ value }];
};
export const createLookupFunction = (key, options = {}) => {
    const [firstPart = '', ...rest] = key.split('.');
    const lookupRest = rest.length > 0 ? createLookupFunction(rest.join('.'), options) : undefined;
    return (doc, arrayIndices) => {
        if (Array.isArray(doc)) {
            if (!(isNumericKey(firstPart) && +firstPart < doc.length)) {
                return [];
            }
            arrayIndices = arrayIndices ? arrayIndices.concat(+firstPart, 'x') : [+firstPart, 'x'];
        }
        const firstLevel = doc[firstPart];
        if (!lookupRest) {
            return buildResult(arrayIndices, Array.isArray(doc) && Array.isArray(firstLevel), firstLevel);
        }
        if (!isIndexable(firstLevel)) {
            if (Array.isArray(doc)) {
                return [];
            }
            return buildResult(arrayIndices, false, undefined);
        }
        const result = lookupRest(firstLevel, arrayIndices);
        if (Array.isArray(firstLevel) && !(isNumericKey(rest[0]) && options.forSort)) {
            firstLevel.forEach((branch, arrayIndex) => {
                if (isPlainObject(branch)) {
                    result.push(...lookupRest(branch, arrayIndices ? [...arrayIndices, arrayIndex] : [arrayIndex]));
                }
            });
        }
        return result;
    };
};
//# sourceMappingURL=lookups.js.map