"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateAgentAssignPermissions = validateAgentAssignPermissions;
exports.canSendOutboundMessage = canSendOutboundMessage;
const core_services_1 = require("@rocket.chat/core-services");
const models_1 = require("@rocket.chat/models");
const addRoleBasedRestrictionsToDepartment_1 = require("../../units/addRoleBasedRestrictionsToDepartment");
async function validateAgentAssignPermissions(userId, agentId) {
    if (await core_services_1.Authorization.hasPermission(userId, 'outbound.can-assign-any-agent')) {
        return;
    }
    if ((await core_services_1.Authorization.hasPermission(userId, 'outbound.can-assign-self-only')) && agentId === userId) {
        return;
    }
    throw new Error('error-invalid-agent');
}
async function canSendOutboundMessage(userId, agentId, departmentId) {
    // Case 1: Check department and check if agent is in department
    if (departmentId) {
        let query = { _id: departmentId };
        if (!(await core_services_1.Authorization.hasPermission(userId, 'outbound.can-assign-queues'))) {
            query = await (0, addRoleBasedRestrictionsToDepartment_1.addQueryRestrictionsToDepartmentsModel)(query, userId);
        }
        const department = await models_1.LivechatDepartment.findOne(query, { _id: 1, enabled: 1 });
        if (!department?.enabled) {
            throw new Error('error-invalid-department');
        }
        // Case 2: Agent & department: if agent is present, agent must be in department
        if (agentId) {
            await validateAgentAssignPermissions(userId, agentId);
            // On here, we take a shortcut: if the user is here, we assume it's an agent (and we assume the collection is kept up to date :) )
            const agent = await models_1.LivechatDepartmentAgents.findOneByAgentIdAndDepartmentId(agentId, departmentId, { projection: { _id: 1 } });
            if (!agent) {
                throw new Error('error-agent-not-in-department');
            }
        }
        // Case 3: Agent & no department: if agent is present and there's no department, agent must be an agent
    }
    else if (agentId) {
        await validateAgentAssignPermissions(userId, agentId);
        const agent = await models_1.Users.findOneAgentById(agentId, { projection: { _id: 1 } });
        if (!agent) {
            throw new Error('error-invalid-agent');
        }
    }
}
//# sourceMappingURL=canSendMessage.js.map