"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addQueryRestrictionsToDepartmentsModel = void 0;
const getUnitsFromUser_1 = require("./getUnitsFromUser");
const logger_1 = require("../utils/logger");
const addQueryRestrictionsToDepartmentsModel = async (originalQuery = {}, userId) => {
    const query = { $and: [originalQuery, { type: { $ne: 'u' } }] };
    const units = await (0, getUnitsFromUser_1.getUnitsFromUser)(userId);
    if (Array.isArray(units)) {
        query.$and.push({ $or: [{ ancestors: { $in: units } }, { _id: { $in: units } }] });
    }
    logger_1.defaultLogger.debug({ msg: 'Applying department query restrictions', userId, units });
    return query;
};
exports.addQueryRestrictionsToDepartmentsModel = addQueryRestrictionsToDepartmentsModel;
//# sourceMappingURL=addRoleBasedRestrictionsToDepartment.js.map