"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUnitsFromUser = void 0;
const core_services_1 = require("@rocket.chat/core-services");
const models_1 = require("@rocket.chat/models");
const mem_1 = __importDefault(require("mem"));
const logger_1 = require("../utils/logger");
async function getUnitsFromUserRoles(user) {
    return models_1.LivechatUnit.findByMonitorId(user);
}
async function getDepartmentsFromUserRoles(user) {
    return (await models_1.LivechatDepartmentAgents.findByAgentId(user).toArray()).map((department) => department.departmentId);
}
const memoizedGetUnitFromUserRoles = (0, mem_1.default)(getUnitsFromUserRoles, { maxAge: process.env.TEST_MODE ? 1 : 10000 });
const memoizedGetDepartmentsFromUserRoles = (0, mem_1.default)(getDepartmentsFromUserRoles, { maxAge: process.env.TEST_MODE ? 1 : 10000 });
async function hasUnits() {
    // @ts-expect-error - this prop is injected dynamically on ee license
    return (await models_1.LivechatUnit.countUnits({ type: 'u' })) > 0;
}
// Units should't change really often, so we can cache the result
const memoizedHasUnits = (0, mem_1.default)(hasUnits, { maxAge: process.env.TEST_MODE ? 1 : 10000 });
const getUnitsFromUser = async (userId) => {
    if (!userId) {
        return;
    }
    if (!(await memoizedHasUnits())) {
        return;
    }
    // TODO: we can combine these 2 calls into one single query
    if (await core_services_1.Authorization.hasAnyRole(userId, ['admin', 'livechat-manager'])) {
        return;
    }
    if (!(await core_services_1.Authorization.hasAnyRole(userId, ['livechat-monitor', 'livechat-agent']))) {
        return;
    }
    const unitsAndDepartments = [...(await memoizedGetUnitFromUserRoles(userId)), ...(await memoizedGetDepartmentsFromUserRoles(userId))];
    logger_1.defaultLogger.debug({ msg: 'Calculating units for monitor', user: userId, unitsAndDepartments });
    return unitsAndDepartments;
};
exports.getUnitsFromUser = getUnitsFromUser;
//# sourceMappingURL=getUnitsFromUser.js.map