"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const i18n_1 = require("@rocket.chat/i18n");
const logger_1 = require("@rocket.chat/logger");
const i18next = __importStar(require("i18next"));
const i18next_sprintf_postprocessor_1 = __importDefault(require("i18next-sprintf-postprocessor"));
const OmnichannelTranscript_1 = require("./OmnichannelTranscript");
const OmnichannelTranscript_fixtures_1 = require("./OmnichannelTranscript.fixtures");
jest.mock('@rocket.chat/pdf-worker', () => ({
    PdfWorker: jest.fn().mockImplementation(() => ({
        renderToStream: jest.fn().mockResolvedValue(Buffer.from('')),
        isMimeTypeValid: jest.fn(() => true),
    })),
}));
jest.mock('@rocket.chat/core-services', () => ({
    ServiceClass: class {
    },
    Upload: {
        getFileBuffer: jest.fn().mockResolvedValue(Buffer.from('')),
        uploadFile: jest.fn().mockResolvedValue({ _id: 'fileId', name: 'fileName' }),
        sendFileMessage: jest.fn(),
    },
    Message: {
        sendMessage: jest.fn(),
    },
    Room: {
        createDirectMessage: jest.fn().mockResolvedValue({ rid: 'roomId' }),
    },
    Settings: {
        get: jest.fn().mockResolvedValue(''),
    },
}));
jest.mock('@rocket.chat/models', () => ({
    LivechatRooms: {
        findOneById: jest.fn().mockResolvedValue({}),
    },
    Messages: {
        findLivechatMessagesWithoutTypes: jest.fn().mockReturnValue({
            toArray: jest.fn().mockResolvedValue([]),
        }),
    },
    Uploads: {
        findOneById: jest.fn().mockResolvedValue({}),
    },
    Users: {
        findOneById: jest.fn().mockResolvedValue({}),
        findOneAgentById: jest.fn().mockResolvedValue({}),
    },
    LivechatVisitors: {
        findOneEnabledById: jest.fn().mockResolvedValue({}),
    },
}));
jest.mock('@rocket.chat/tools', () => ({
    guessTimezone: jest.fn().mockReturnValue('UTC'),
    guessTimezoneFromOffset: jest.fn().mockReturnValue('UTC'),
    streamToBuffer: jest.fn().mockResolvedValue(Buffer.from('')),
}));
describe('OmnichannelTranscript', () => {
    let omnichannelTranscript;
    beforeEach(async () => {
        const i18n = i18next.use(i18next_sprintf_postprocessor_1.default);
        i18next.use(i18next_sprintf_postprocessor_1.default);
        await i18n.init({
            lng: 'en',
            fallbackLng: 'en',
            defaultNS: i18n_1.defaultTranslationNamespace,
            ns: i18n_1.availableTranslationNamespaces,
            nsSeparator: '.',
            resources: {
                en: (0, i18n_1.extractTranslationNamespaces)({
                    Conversation_closed: 'Conversation closed: {{comment}}.',
                }),
            },
            initImmediate: true,
        });
        omnichannelTranscript = new OmnichannelTranscript_1.OmnichannelTranscript(logger_1.Logger, i18n);
    });
    it('should return default timezone', async () => {
        const timezone = await omnichannelTranscript.getTimezone();
        expect(timezone).toBe('UTC');
    });
    it('should parse the messages', async () => {
        const parsedMessages = await omnichannelTranscript.getMessagesData(OmnichannelTranscript_fixtures_1.messages, i18next.t);
        expect(parsedMessages).toBeDefined();
        expect(parsedMessages).toHaveLength(3);
        expect(parsedMessages[0]).toHaveProperty('files');
        expect(parsedMessages[0].files).toHaveLength(0);
        expect(parsedMessages[0]).toHaveProperty('quotes');
        expect(parsedMessages[0].quotes).toHaveLength(0);
    });
    it('should parse system message without a valid translation key', async () => {
        const parsedMessages = await omnichannelTranscript.getMessagesData([...OmnichannelTranscript_fixtures_1.messages, OmnichannelTranscript_fixtures_1.validSystemMessage], i18next.t);
        const systemMessage = parsedMessages[3];
        expect(parsedMessages).toBeDefined();
        expect(parsedMessages).toHaveLength(4);
        expect(systemMessage).toHaveProperty('t');
        expect(systemMessage.t).toBe('livechat-started');
        expect(systemMessage).toHaveProperty('msg');
        expect(systemMessage.msg).toBe('Chat_started');
        expect(systemMessage).toHaveProperty('files');
        expect(systemMessage.files).toHaveLength(0);
        expect(systemMessage).toHaveProperty('quotes');
        expect(systemMessage.quotes).toHaveLength(0);
    });
    it('should translate a system message with available translation keys', async () => {
        const parsedMessages = await omnichannelTranscript.getMessagesData([...OmnichannelTranscript_fixtures_1.messages, OmnichannelTranscript_fixtures_1.validTranslatableSystemMessage], i18next.t);
        const systemMessage = parsedMessages[3];
        expect(parsedMessages).toBeDefined();
        expect(parsedMessages).toHaveLength(4);
        expect(systemMessage).toHaveProperty('t');
        expect(systemMessage.t).toBe('livechat-close');
        expect(systemMessage).toHaveProperty('msg');
        expect(systemMessage.msg).toBe('Conversation closed: Conversation closed by user.');
        expect(systemMessage).toHaveProperty('files');
        expect(systemMessage.files).toHaveLength(0);
        expect(systemMessage).toHaveProperty('quotes');
        expect(systemMessage.quotes).toHaveLength(0);
    });
    it('should translate a system message to the default language when the server language provided doesnt work', async () => {
        const parsedMessages = await omnichannelTranscript.getMessagesData([...OmnichannelTranscript_fixtures_1.messages, OmnichannelTranscript_fixtures_1.validTranslatableSystemMessage], i18next.getFixedT('es'));
        const systemMessage = parsedMessages[3];
        expect(parsedMessages).toBeDefined();
        expect(parsedMessages).toHaveLength(4);
        expect(systemMessage).toHaveProperty('t');
        expect(systemMessage.t).toBe('livechat-close');
        expect(systemMessage).toHaveProperty('msg');
        expect(systemMessage.msg).toBe('Conversation closed: Conversation closed by user.');
        expect(systemMessage).toHaveProperty('files');
        expect(systemMessage.files).toHaveLength(0);
        expect(systemMessage).toHaveProperty('quotes');
        expect(systemMessage.quotes).toHaveLength(0);
    });
    it('should parse an invalid system message', async () => {
        const parsedMessages = await omnichannelTranscript.getMessagesData([...OmnichannelTranscript_fixtures_1.messages, OmnichannelTranscript_fixtures_1.invalidSystemMessage], i18next.t);
        const systemMessage = parsedMessages[3];
        expect(parsedMessages).toBeDefined();
        expect(parsedMessages).toHaveLength(4);
        expect(systemMessage).toHaveProperty('t');
        expect(systemMessage.t).toBe('some-system-message');
        expect(systemMessage.msg).toBeUndefined();
    });
});
//# sourceMappingURL=OmnichannelTranscript.spec.js.map