var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { FieldGroup, Field, EmailInput, PasswordInput, Button, Box, FieldLabel, FieldRow, FieldError, } from '@rocket.chat/fuselage';
import { Form, ActionLink } from '@rocket.chat/layout';
import { useForm } from 'react-hook-form';
import { Trans, useTranslation } from 'react-i18next';
import { LoginActionsWrapper } from './LoginForm.styles';
var LoginForm = function (_a) {
    var onSubmit = _a.onSubmit, initialValues = _a.initialValues, _b = _a.isPasswordLess, isPasswordLess = _b === void 0 ? false : _b, onChangeForm = _a.onChangeForm, onResetPassword = _a.onResetPassword, formError = _a.formError;
    var t = useTranslation().t;
    var _c = useForm({
        defaultValues: __assign({}, initialValues),
    }), register = _c.register, handleSubmit = _c.handleSubmit, _d = _c.formState, errors = _d.errors, isValidating = _d.isValidating, isSubmitting = _d.isSubmitting, isDirty = _d.isDirty;
    return (_jsxs(Form, { onSubmit: handleSubmit(onSubmit), children: [_jsxs(Form.Header, { children: [_jsx(Form.Title, { children: t('form.loginForm.content.logIn') }), _jsx(Form.Subtitle, { children: !isPasswordLess
                            ? t('form.loginForm.content.default')
                            : t('form.loginForm.content.passwordLess') })] }), _jsx(Form.Container, { children: _jsxs(FieldGroup, { children: [_jsxs(Field, { children: [_jsx(FieldLabel, { children: t('form.loginForm.fields.email.label') }), _jsx(FieldRow, { children: _jsx(EmailInput, __assign({}, register('email', {
                                        required: t('component.form.requiredField'),
                                    }), { placeholder: t('form.loginForm.fields.email.placeholder') })) }), errors.email && _jsx(FieldError, { children: errors.email.message })] }), !isPasswordLess && (_jsxs(Field, { children: [_jsx(FieldLabel, { children: t('form.loginForm.fields.password.label') }), _jsx(FieldRow, { children: _jsx(PasswordInput, __assign({}, register('password', { required: true }), { placeholder: t('form.loginForm.fields.password.placeholder') })) }), (formError || errors.password) && (_jsx(FieldError, { children: t('form.loginForm.fields.password.error') }))] }))] }) }), _jsxs(Form.Footer, { children: [_jsxs(LoginActionsWrapper, { children: [_jsx(Button, { type: 'submit', loading: isValidating || isSubmitting, disabled: !isDirty, primary: true, children: isPasswordLess
                                    ? t('form.loginForm.sendLoginLink')
                                    : t('form.loginForm.button.text') }), !isPasswordLess && (_jsx(ActionLink, { fontScale: 'p2', onClick: onChangeForm, children: t('form.loginForm.sendLoginLink') })), isPasswordLess && (_jsx(ActionLink, { fontScale: 'p2', onClick: onChangeForm, children: t('form.loginForm.redirect') }))] }), !isPasswordLess && (_jsx(Box, { mbs: 24, fontScale: 'p2', textAlign: 'left', children: _jsxs(Trans, { i18nKey: 'form.loginForm.resetPassword', children: ["Forgot your password?", _jsx(ActionLink, { fontScale: 'p2', onClick: onResetPassword, children: "Reset password" })] }) }))] })] }));
};
export default LoginForm;
//# sourceMappingURL=LoginForm.js.map