var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Form } from '@rocket.chat/layout';
import { useState } from 'react';
import { useForm, FormProvider } from 'react-hook-form';
import { useTranslation } from 'react-i18next';
import CopyStep from './steps/CopyStep';
import PasteStep from './steps/PasteStep';
export var Steps = {
    COPY: 'copy',
    PASTE: 'paste',
};
var RegisterOfflineForm = function (_a) {
    var termsHref = _a.termsHref, policyHref = _a.policyHref, clientKey = _a.clientKey, onSubmit = _a.onSubmit, onCopySecurityCode = _a.onCopySecurityCode, onBackButtonClick = _a.onBackButtonClick;
    var t = useTranslation().t;
    var _b = useState(Steps.COPY), step = _b[0], setStep = _b[1];
    var form = useForm({
        mode: 'onChange',
        defaultValues: {
            token: '',
            agreement: false,
        },
    });
    var handleSubmit = form.handleSubmit;
    return (_jsx(FormProvider, __assign({}, form, { children: _jsxs(Form, { onSubmit: handleSubmit(onSubmit), children: [_jsx(Form.Header, { children: _jsx(Form.Title, { children: t('form.registerOfflineForm.title') }) }), step === Steps.COPY ? (_jsx(CopyStep, { termsHref: termsHref, policyHref: policyHref, clientKey: clientKey, setStep: setStep, onCopySecurityCode: onCopySecurityCode, onBackButtonClick: onBackButtonClick })) : (_jsx(PasteStep, { setStep: setStep }))] }) })));
};
export default RegisterOfflineForm;
//# sourceMappingURL=RegisterOfflineForm.js.map