import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Icon } from '@rocket.chat/fuselage';
import colors from '@rocket.chat/fuselage-tokens/colors.json';
import { List, DarkModeProvider } from '@rocket.chat/layout';
import { useMemo } from 'react';
import { renderToStaticMarkup } from 'react-dom/server';
import { useTranslation } from 'react-i18next';
import PlanFeatureIcon from '../../common/PlanFeatureIcon';
var Description = function () {
    var isDarkMode = DarkModeProvider.useDarkMode();
    var color = isDarkMode ? colors.white : colors.n900;
    var t = useTranslation().t;
    var featuresList = [
        t('page.createCloudWorkspace.auditing'),
        t('page.createCloudWorkspace.numberOfIntegrations'),
        t('page.createCloudWorkspace.ldap'),
        t('page.createCloudWorkspace.omnichannel'),
        t('page.createCloudWorkspace.sla'),
        t('page.createCloudWorkspace.push'),
        t('page.createCloudWorkspace.engagement'),
    ];
    var icon = useMemo(function () {
        return encodeURIComponent(renderToStaticMarkup(_jsx(PlanFeatureIcon, { color: color })));
    }, [color]);
    var listItem = function (text, id) { return (_jsxs(List.Item, { fontScale: 'p1', children: [_jsx(Icon, { name: 'check', size: 'x24', mie: 12 }), text] }, id)); };
    return (_jsx(Box, { children: _jsx(Box, { children: _jsx(List, { color: color, spacing: 'x16', icon: icon, children: featuresList.map(function (text, id) { return listItem(text, id); }) }) }) }));
};
export default Description;
//# sourceMappingURL=Description.js.map