import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Button } from '@rocket.chat/fuselage';
import colors from '@rocket.chat/fuselage-tokens/colors.json';
import { VerticalWizardLayout, VerticalWizardLayoutTitle, VerticalWizardLayoutForm, } from '@rocket.chat/layout';
import { Trans, useTranslation } from 'react-i18next';
var OauthAuthorizationPage = function (_a) {
    var clientName = _a.clientName, onClickAuthorizeOAuth = _a.onClickAuthorizeOAuth, error = _a.error;
    var t = useTranslation().t;
    return (_jsxs(VerticalWizardLayout, { children: [_jsx(VerticalWizardLayoutTitle, { children: t('page.oauthAuthorizationPage.title') }), _jsx(VerticalWizardLayoutForm, { children: _jsx(Box, { fontScale: 'p1', p: 40, textAlign: 'start', color: colors.n900, children: !clientName || error.message ? (_jsxs(_Fragment, { children: [_jsx(Box, { fontScale: 'h1', mbe: 18, children: "Error" }), error.message, _jsx(Box, { mbs: 24, children: _jsx(Button, { onClick: error.onGoBack, primary: true, children: t('page.oauthAuthorizationPage.buttons.goBack') }) })] })) : (_jsxs(_Fragment, { children: [_jsxs(Trans, { i18nKey: 'page.oauthAuthorizationPage.allowLogin', values: { name: clientName }, children: ["Do you wish to allow", _jsx("strong", { children: clientName }), "to login with your Rocket.Chat Cloud Account?"] }), _jsx(Box, { mbs: 24, children: _jsx(Button, { onClick: onClickAuthorizeOAuth, primary: true, children: t('page.oauthAuthorizationPage.buttons.authorize') }) })] })) }) })] }));
};
export default OauthAuthorizationPage;
//# sourceMappingURL=OauthAuthorizationPage.js.map